/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.impl;

import com.jslope.security.crypto.EncryptedBytes;
import com.jslope.security.crypto.JSlopePublicKey;
import com.jslope.security.crypto.JSlopeSignatureVerifier;
import com.jslope.security.crypto.JSlopeSymetricKey;
import com.jslope.security.crypto.SymetricKeyFactory;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.JSlopeDigest;
import com.jslope.security.crypto.impl.JSlopeEncryptedBytes;
import com.jslope.security.crypto.impl.RSAKey;
import com.jslope.security.crypto.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSAPublicKey
extends RSAKey
implements JSlopeSignatureVerifier,
JSlopePublicKey {
    public RSAPublicKey() {
    }

    public RSAPublicKey(CipherParameters publicKey) {
        this.key = publicKey;
    }

    public RSAPublicKey(byte[] publicKeyBytes) {
        this.load(publicKeyBytes);
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        RSAKeyParameters rsaKey = (RSAKeyParameters)this.key;
        try {
            aOut.writeObject((Object)new RSAPublicKeyStructure(rsaKey.getModulus(), rsaKey.getExponent()));
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public void load(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ASN1InputStream as1in = new ASN1InputStream((InputStream)bis);
        try {
            ASN1Sequence asn = (ASN1Sequence)as1in.readObject();
            RSAPublicKeyStructure structure = new RSAPublicKeyStructure(asn);
            this.key = new RSAKeyParameters(false, structure.getModulus(), structure.getPublicExponent());
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public boolean isValid(byte[] message, byte[] signature) throws CryptogException {
        byte[] messageDigest = JSlopeDigest.digest(message);
        try {
            byte[] signatureDigest = this.internalDecrypt(signature);
            return Utils.compareBytes(messageDigest, signatureDigest);
        }
        catch (CryptogException e) {
            e.printStackTrace();
            if (e.getCause() instanceof InvalidCipherTextException) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public EncryptedBytes encrypt(byte[] message) throws CryptogException {
        JSlopeSymetricKey skey = SymetricKeyFactory.generateKey();
        byte[] encrypted = skey.encrypt(message);
        byte[] key = skey.getBytes();
        byte[] encryptedKey = this.internalEncrypt(key);
        return new JSlopeEncryptedBytes(encryptedKey, encrypted);
    }

    @Override
    public byte[] encryptLowLevel(byte[] bytes) throws CryptogException {
        return this.internalEncrypt(bytes);
    }
}

