/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.impl.JSlopeDomain;
import com.jslope.security.impl.JSlopePublicDomain;
import java.io.IOException;

public class DomainFactory {
    public static Domain newDomain() {
        return new JSlopeDomain();
    }

    public static Domain newDomain(String name) {
        Domain domain = DomainFactory.newDomain();
        domain.generate();
        domain.setName(name);
        return domain;
    }

    public static PublicDomain deserializePublicDomain(AdvancedDataInput is) throws IOException {
        PublicDomain publicDomain = DomainFactory.newPublicDomain();
        publicDomain.deserialize(is);
        return publicDomain;
    }

    public static PublicDomain newPublicDomain() {
        return new JSlopePublicDomain();
    }

    public static String subdomainName(String subName, String domainName) {
        return subName + "." + domainName;
    }
}

