/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.security.Domain;
import com.jslope.security.IDPermit;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.AbstractObjectSignedByDomain;
import java.io.IOException;

public class JSlopeIDPermit
extends AbstractObjectSignedByDomain
implements IDPermit {
    public JSlopeIDPermit(String idName, String key, Domain domain) throws CryptogException {
        this.signedObject = new IDNameAndKey(idName, key);
        this.publicDomain = domain.getPublicPart();
        this.sign(domain);
    }

    public JSlopeIDPermit() {
    }

    @Override
    public StreamSerializable newSignedObject() {
        return new IDNameAndKey();
    }

    @Override
    public String getIDName() {
        return ((IDNameAndKey)this.signedObject).getIDName();
    }

    @Override
    public String getKey() {
        return ((IDNameAndKey)this.signedObject).getKey();
    }

    class IDNameAndKey
    implements StreamSerializable {
        String idName;
        String key;

        IDNameAndKey() {
        }

        IDNameAndKey(String idName, String key) {
            this.idName = idName;
            this.key = key;
        }

        @Override
        public void serialize(AdvancedDataOutput os) throws IOException {
            os.writeUTF(this.idName);
            os.writeUTF(this.key);
        }

        @Override
        public void deserialize(AdvancedDataInput is) throws IOException {
            this.idName = is.readUTF();
            this.key = is.readUTF();
        }

        public String getIDName() {
            return this.idName;
        }

        public String getKey() {
            return this.key;
        }
    }
}

