/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.framework.DNS;
import com.jslope.framework.IDManager;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.messages.DefaultMailMessage;
import com.jslope.io.protocol.messages.DefaultOpenMessage;
import com.jslope.io.protocol.messages.MailMessage;
import com.jslope.io.protocol.messages.OpenMessage;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.logger.Log;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.Signable;
import com.jslope.security.SignedMessage;
import com.jslope.security.crypto.EncryptedBytes;
import com.jslope.security.crypto.JSlopePrivateKey;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.RSAKeyPair;
import com.jslope.security.crypto.impl.RSAPrivateKey;
import com.jslope.security.crypto.utils.Utils;
import com.jslope.security.impl.AbstractSecureObject;
import com.jslope.security.impl.JSlopePublicID;
import com.jslope.security.impl.JSlopeSignedMessage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class JSlopeSecureID
extends AbstractSecureObject
implements SecureID {
    JSlopePrivateKey decryptor;
    JSlopePrivateKey signer;
    JSlopePublicID publicID;
    String name;

    protected JSlopeSecureID() {
    }

    @Override
    public void generate() {
        RSAKeyPair cryptorPair = new RSAKeyPair();
        cryptorPair.generate();
        this.decryptor = cryptorPair.getPrivateKey();
        RSAKeyPair signerPair = new RSAKeyPair();
        signerPair.generate();
        this.signer = signerPair.getPrivateKey();
        this.publicID = new JSlopePublicID(cryptorPair.getPublicKey(), signerPair.getPublicKey(), this.name);
    }

    @Override
    public PublicID getPublicPart() {
        return this.publicID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void reintegrate(PublicID publicID) throws CryptogException {
        if (this.getName().equals(publicID.getName()) && publicID.isSigned()) {
            if (this.getPublicPart().isEqualWithUnsingedID(publicID)) {
                this.publicID = (JSlopePublicID)publicID;
                return;
            }
            Log.error("Public parts aren't equal");
        } else {
            Log.error("Names aren't equal, or public id is not signed");
        }
        throw new CryptogException("Can't integrate public ID " + publicID.getName() + " into secure ID " + this.getName());
    }

    private void verifyWorkability() {
        byte[] testString = "dfidfjhosifjhoidsjifs".getBytes();
        try {
            PublicID publicID = this.getPublicPart();
            byte[] encrypted = publicID.encryptLowLevelBytes(testString);
            byte[] decrypted = this.decryptLowLevelBytes(encrypted);
            if (Utils.compareBytes(testString, decrypted)) {
                Log.debug("Encryption decription worked successfully");
            } else {
                Log.error("There were errors during encryption/decription");
            }
        }
        catch (CryptogException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SignedMessage signMessage(String stringMessage) throws CryptogException {
        return this.signMessage(Utils.stringToBytes(stringMessage));
    }

    @Override
    public SignedMessage signMessage(byte[] byteMessage) throws CryptogException {
        JSlopeSignedMessage signedMessage = new JSlopeSignedMessage();
        signedMessage.setBytes(byteMessage);
        signedMessage.setSignature(this.signLowLevelBytes(byteMessage), this.getPublicPart());
        return signedMessage;
    }

    @Override
    public byte[] signLowLevelBytes(byte[] bytesToSign) throws CryptogException {
        return this.signer.sign(bytesToSign);
    }

    @Override
    public byte[] decryptBytes(EncryptedBytes encryptedBytes) throws CryptogException {
        return this.decryptor.decrypt(encryptedBytes);
    }

    @Override
    public byte[] decryptLowLevelBytes(byte[] encryptedByte) throws CryptogException {
        return this.decryptor.decryptLowLevel(encryptedByte);
    }

    @Override
    public boolean sendMessage(String destinationIDName, String textMessage, ErrorHandler errorHandler) throws CryptogException {
        PublicID destinationID = DNS.getID(destinationIDName, errorHandler);
        MailMessage messageToSend = this.createMessage(destinationID, textMessage, errorHandler);
        return IDManager.sendMessage(messageToSend, (SecureID)this, errorHandler);
    }

    @Override
    public boolean sendMessage(String destinationIDName, String textMessage, Iterable<File> attachments, ErrorHandler errorHandler) throws CryptogException {
        PublicID destinationID = DNS.getID(destinationIDName, errorHandler);
        MailMessage messageToSend = this.createMessage(destinationID, textMessage, attachments, errorHandler);
        return IDManager.sendMessage(messageToSend, (SecureID)this, errorHandler);
    }

    @Override
    public boolean sendMessage(OpenMessage openMessage, ErrorHandler errorHandler) throws CryptogException {
        if (!openMessage.isSigned()) {
            this.sign(openMessage);
        }
        PublicID destinationID = openMessage.getDestinationID();
        MailMessage messageToSend = this.createMessage(destinationID, openMessage, errorHandler);
        return IDManager.sendMessage(messageToSend, (SecureID)this, errorHandler);
    }

    @Override
    public void sign(Signable message) throws CryptogException {
        byte[] signature = this.signLowLevelBytes(message.getUnsignedBytes());
        message.setSignature(signature);
    }

    @Override
    public List<OpenMessage> receive(ErrorHandler errorHandler) throws CryptogException {
        List<MailMessage> encryptedMessages = IDManager.receiveMessages(this, errorHandler);
        if (errorHandler.hasErrors()) {
            System.out.println("Tthere were errors during e-mail checking... ");
        }
        if (encryptedMessages == null) {
            System.out.println("ecnrypted messages is null!!! ");
            encryptedMessages = new LinkedList<MailMessage>();
        }
        LinkedList<OpenMessage> openMessages = new LinkedList<OpenMessage>();
        for (MailMessage encrypted : encryptedMessages) {
            encrypted.verifySignature();
            openMessages.add(this.decrypt(encrypted));
        }
        return openMessages;
    }

    public OpenMessage decrypt(MailMessage encryptedMessage) throws CryptogException {
        EncryptedBytes encryptedBytes = encryptedMessage.getEncryptedBytes();
        byte[] decripted = this.decryptBytes(encryptedBytes);
        return DefaultOpenMessage.newFromBytes(decripted);
    }

    @Override
    public MailMessage createMessage(PublicID destinationID, String subject, String textMessage, ErrorHandler errorHandler) throws CryptogException {
        return this.createMessage(destinationID, subject, textMessage, false, errorHandler);
    }

    @Override
    public MailMessage createMessage(PublicID destinationID, String subject, String textMessage, boolean isBounced, ErrorHandler errorHandler) throws CryptogException {
        OpenMessage openMsg = this.createOpenMessage(destinationID, subject, textMessage);
        return this.createMessage(destinationID, openMsg, errorHandler);
    }

    public MailMessage createMessage(PublicID destinationID, String textMessage, ErrorHandler errorHandler) throws CryptogException {
        OpenMessage openMsg = this.createOpenMessage(destinationID, textMessage);
        return this.createMessage(destinationID, openMsg, errorHandler);
    }

    public MailMessage createMessage(PublicID destinationID, String textMessage, Iterable<File> attachments, ErrorHandler errorHandler) throws CryptogException {
        OpenMessage openMsg = this.createOpenMessage(destinationID, textMessage, attachments, errorHandler);
        return this.createMessage(destinationID, openMsg, errorHandler);
    }

    public MailMessage createMessage(PublicID destinationID, OpenMessage openMsg, ErrorHandler errorHandler) throws CryptogException {
        return this.createMessage(destinationID, openMsg, false, errorHandler);
    }

    public MailMessage createMessage(PublicID destinationID, OpenMessage openMsg, boolean isBounced, ErrorHandler errorHandler) throws CryptogException {
        EncryptedBytes encrypted = destinationID.encryptBytes(openMsg.toBytes());
        DefaultMailMessage message = new DefaultMailMessage(destinationID, this.getPublicPart(), encrypted);
        message.setIsBounced(isBounced);
        byte[] signature = this.signer.sign(message.getUnsignedBytes());
        message.setSignature(signature);
        return message;
    }

    private OpenMessage createOpenMessage(PublicID destinationID, String textMessage) throws CryptogException {
        return this.createOpenMessage(destinationID, "", textMessage);
    }

    private OpenMessage createOpenMessage(PublicID destinationID, String subject, String textMessage) throws CryptogException {
        DefaultOpenMessage message = new DefaultOpenMessage(this.getPublicPart(), destinationID, subject, textMessage);
        byte[] signature = this.signer.sign(message.getUnsignedBytes());
        message.setSignature(signature);
        return message;
    }

    private OpenMessage createOpenMessage(PublicID destinationID, String textMessage, Iterable<File> attachments, ErrorHandler errorHandler) throws CryptogException {
        DefaultOpenMessage message = new DefaultOpenMessage(this.getPublicPart(), destinationID, "", textMessage);
        message.setAttachments(attachments);
        byte[] signature = this.signer.sign(message.getUnsignedBytes());
        message.setSignature(signature);
        return message;
    }

    @Override
    public void serialize(AdvancedDataOutput dos) throws IOException {
        this.publicID.serialize(dos);
        dos.writeUTF(this.name);
        this.signer.serialize(dos);
        this.decryptor.serialize(dos);
    }

    @Override
    public void deserialize(AdvancedDataInput bis) throws IOException {
        this.publicID = new JSlopePublicID();
        this.publicID.deserialize(bis);
        this.name = bis.readUTF();
        this.signer = new RSAPrivateKey();
        this.decryptor = new RSAPrivateKey();
        this.signer.deserialize(bis);
        this.decryptor.deserialize(bis);
    }

    @Override
    protected File defaultFile() {
        return new File(this.defaultFileName());
    }

    public String defaultFileName() {
        return this.getName() + ".secure";
    }

    @Override
    public String show() {
        return this.getName();
    }
}

